function [ G_est, conv ] = ReflectionChannelEstimation( Y, Phi, options, G )
%REFLECTIONCHANNELESTIMATION Summary of this function goes here
%   Detailed explanation goes here
% Y = Y/sqrt(options.Tx_power);
A = zeros(options.M, options.N+1, options.M);
for i = 1:options.L
    tx = options.Tx_id(i);
    for k = 1:options.M
        if (k~=tx)
            A(tx,:,k) = Y(tx,:,k)*inv(Phi)/sqrt(options.Tx_power); % estimating downlink-uplink combined channel tensor for the 
        end
    end
end

G_est = zeros(options.M,options.N);
err_list = zeros(options.M,1);

conv = zeros(options.I_max+1,options.N);
f0 = 0;
for j = 1:options.N
    Ai = squeeze(A(:,j+1,:));
    for n1=1:options.L
        tx = options.Tx_id(n1);
        for n2=1:options.M
            if (tx~=n2)
                f0 = f0 + abs(Ai(tx,n2))^2;
            end
        end
    end
    Bi = Ai(options.Tx_id,:);
    for tt=1:20
        
        [~,st] = sort(abs(Bi(1:end)),'descend');
        k = 1;
        while (1)
            n2 = options.Tx_id(mod(st(k)-1,options.L)+1);
            n3 = ceil(st(k)/options.L);
            if (n2 == n3)
                k = k+1;
                continue;
            end
            if (options.L==2)
                if (find(options.Tx_id==n2))
                    if (find(options.Tx_id==n3))
                        k = k+1;
                        continue;
                    end
                end
            end
            break;
        end
        
        for tx = 1:options.L
            nn = options.Tx_id(tx);
            if ((nn~=n2) && (nn~=n3))
                n1 = nn;
                break;
            end
        end
        
        
        pp = Ai(n1,n2)*Ai(n1,n3)/Ai(n2,n3);
        p = zeros(options.M,1);
        p(n1)=sqrt(pp);
        for ii = 1:options.M
            if (n1~=ii)
                p(ii) = Ai(n1,ii)/p(n1);
            end
        end
        f = 0;
        for n1=1:options.L
            tx = options.Tx_id(n1);
            for n2=1:options.M
                if (tx~=n2)
                    f = f + abs(Ai(tx,n2)-p(tx)*p(n2))^2;
                end
            end
        end
        conv(1,j) = f;
        for t = 1:options.I_max % outer iteration
            for n = 1:options.M % inner iteration 
                %% here we update p(n)
                %% sum up the numerator and the denominator
                nume = 0;
                deno = 0;
                for slot_id = 1:options.L
                    m1 = options.Tx_id(slot_id);
                    for m2 = 1:options.M
                        if (m2~=m1)
                            if (n==m1)
                                nume = nume + Ai(m1,m2)*conj(p(m2));
                                deno = deno + p(m2)*conj(p(m2));
                            elseif (n==m2)
                                nume = nume + Ai(m1,m2)*conj(p(m1));
                                deno = deno + p(m1)*conj(p(m1));
                            end
                        end
                    end
                end
                %p(n) = nume/(deno+options.SI_plus_noise_var/options.sigma_G/(options.N+1));
                p(n) = nume/deno;
            end
            f = 0;
            for slot_id=1:options.L
                m1 = options.Tx_id(slot_id);
                for m2=1:options.M
                    if (m1~=m2)
                        f = f + abs(Ai(m1,m2)-p(m1)*p(m2))^2;
                    end
                end
            end
            conv(t+1,j) = f;
        end
        if (f<0.001)
            break;
        end
    end
    gi_est = p; % the final estimate of the channel between the BS and the j-th RIS element
    G_est(:,j) = gi_est;
    err_list(j) = min(norm(gi_est - G(:,j),'fro'),norm(-gi_est - G(:,j),'fro')); % error under the existence of sign ambiguity
end

end

